/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sfp.srvutil;

import com.ibm.hsc.sfp.topology.NetworkTopology;
import com.ibm.hsc.sfp.topology.NetworkTopologyConstants;
import com.ibm.hsc.sfp.topology.NetworkTopologyNode;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.NodeDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskSelectionEvent;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;

public class NetworkTopologyBean
extends PanelBean
implements TaskSelectionListener,
NetworkTopologyConstants {
    private String m_sCurrentTopologyTree;
    private NodeDescriptor[] m_ndCurrentTopologyTree;
    private NodeDescriptor[] m_ndCurrentTopologyTreeSelection;
    private String m_sSavedTopologyTree;
    private NodeDescriptor[] m_ndSavedTopologyTree;
    private NodeDescriptor[] m_ndSavedTopologyTreeSelection;
    private UserTaskManager utm = null;
    private HashMap allNodesHashMap = new HashMap();
    private NetworkTopology currentTopology = null;
    private NetworkTopology savedTopology = null;
    private NetworkTopologyNode selectedCurrentNode = null;
    private NetworkTopologyNode selectedSavedNode = null;
    private int nameCtr = 0;
    private static final String TRACE_MASKT = "JNETTOPT";
    private static final String TRACE_MASKF = "JNETTOPF";
    private static final String TRACE_MASKD = "JNETTOPD";

    public NetworkTopologyBean(NetworkTopology networkTopology, NetworkTopology networkTopology2) {
        this.currentTopology = networkTopology;
        this.savedTopology = networkTopology2;
    }

    public void setCurrentTopologyTreeSelection(NodeDescriptor[] nodeDescriptorArray) {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.setCurrentTopologyTreeSelection()");
        this.m_ndCurrentTopologyTreeSelection = nodeDescriptorArray;
    }

    public NodeDescriptor[] getCurrentTopologyTreeSelection() {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.getCurrentTopologyTreeSelection()");
        return this.m_ndCurrentTopologyTreeSelection;
    }

    public void setCurrentTopologyTreeTreeParent(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.setCurrentTopologyTreeTreeParent()");
        this.m_sCurrentTopologyTree = string;
    }

    public NodeDescriptor[] getCurrentTopologyTreeChildren() {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.getCurrentTopologyTreeTreeParent()");
        return this.m_ndCurrentTopologyTree;
    }

    public void setSavedTopologyTreeSelection(NodeDescriptor[] nodeDescriptorArray) {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.setSavedTopologyTreeSelection()");
        this.m_ndSavedTopologyTreeSelection = nodeDescriptorArray;
    }

    public NodeDescriptor[] getSavedTopologyTreeSelection() {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.getSavedTopologyTreeSelection()");
        return this.m_ndSavedTopologyTreeSelection;
    }

    public void setSavedTopologyTreeTreeParent(String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.setSavedTopologyTreeTreeParent()");
        this.m_sSavedTopologyTree = string;
    }

    public NodeDescriptor[] getSavedTopologyTreeChildren() {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.getSavedTopologyTreeChildren()");
        return this.m_ndSavedTopologyTree;
    }

    public Capabilities getCapabilities() {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.getCapabilities()");
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.verifyChanges()");
    }

    public void load() {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.load()");
    }

    public void prepare() {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopologyBean.prepare()");
        this.utm = this.getUserTaskManager();
        this.utm.addTaskSelectionListener((TaskSelectionListener)this, "CurrentTopologyTree");
        this.utm.addTaskSelectionListener((TaskSelectionListener)this, "SavedTopologyTree");
        this.populateTree(this.currentTopology, "CurrentTopologyTree");
        this.populateTree(this.savedTopology, "SavedTopologyTree");
        this.selectedCurrentNode = null;
        this.selectedSavedNode = null;
        this.utm.setEnabled("Button1", false);
        this.utm.setEnabled("Button2", false);
        if (this.savedTopology != null) {
            long l = this.savedTopology.getLastSavedTimestamp();
            String string = "";
            if (l > 0L) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                string = dateFormat.format(new Date(l));
            }
            Trace.trace((String)TRACE_MASKF, (Object)("NetworkTopologyBean.prepare() saved timestamp: " + string));
            this.utm.setValue("Timestamp", string);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopologyBean.prepare()");
    }

    private void populateTree(NetworkTopology networkTopology, String string) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopologyBean.populateTree()");
        this.nameCtr = 0;
        if (networkTopology == null || networkTopology.getRoot() == null) {
            return;
        }
        NetworkTopologyNode networkTopologyNode = networkTopology.getRoot();
        NodeDescriptor nodeDescriptor = this.createNode(networkTopologyNode, null, string);
        this.populateChildren(networkTopologyNode, nodeDescriptor, string);
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopologyBean.populateTree()");
    }

    private void populateChildren(NetworkTopologyNode networkTopologyNode, NodeDescriptor nodeDescriptor, String string) {
        NetworkTopologyNode[] networkTopologyNodeArray = networkTopologyNode.getChildren();
        if (networkTopologyNodeArray != null) {
            for (int i = 0; i < networkTopologyNodeArray.length; ++i) {
                NetworkTopologyNode networkTopologyNode2 = networkTopologyNodeArray[i];
                NodeDescriptor nodeDescriptor2 = this.createNode(networkTopologyNode2, nodeDescriptor.getName(), string);
                this.populateChildren(networkTopologyNode2, nodeDescriptor2, string);
            }
        }
    }

    private NodeDescriptor createNode(NetworkTopologyNode networkTopologyNode, String string, String string2) {
        NodeDescriptor nodeDescriptor = new NodeDescriptor();
        String string3 = networkTopologyNode.getNodeLabel();
        String string4 = string2 + this.nameCtr++;
        nodeDescriptor.setName(string4);
        nodeDescriptor.setTitle(string3);
        String string5 = networkTopologyNode.getImageName();
        if (string5 != null) {
            nodeDescriptor.setImageSrc(string5);
            nodeDescriptor.setImageSrcOpened(string5);
        }
        nodeDescriptor.setLeaf(networkTopologyNode.isTerminal());
        nodeDescriptor.setExpandRequested(true);
        this.allNodesHashMap.put(string4, networkTopologyNode);
        this.utm.addNode(string2, string, null, nodeDescriptor);
        return nodeDescriptor;
    }

    public void save() {
        Trace.trace((String)TRACE_MASKT, (Object)"<-> NetworkTopologyBean.save()");
    }

    public void update(Object object) {
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            this.utm.setValue(stringArray[1], stringArray[0]);
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopologyBean.panelAction()");
        PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
        String string = taskActionEvent.getElementName();
        if (string.equals("ExitButton")) {
            panelTaskletRequest.setDisposed();
        } else {
            panelTaskletRequest.setData("TopoButtonName", (Object)string);
            if (string.equals("Button1")) {
                panelTaskletRequest.setData("TopoNode", (Object)this.selectedCurrentNode);
            } else if (string.equals("Button2")) {
                panelTaskletRequest.setData("TopoNode", (Object)this.selectedSavedNode);
            }
        }
        this.postTaskletRequest(panelTaskletRequest);
        Trace.trace((String)TRACE_MASKT, (Object)("<- NetworkTopologyBean.panelAction() posted request for " + string));
    }

    public void selectionChanged(TaskSelectionEvent taskSelectionEvent) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopologyBean.selectionChanged()");
        String string = taskSelectionEvent.getElementName();
        String[] stringArray = this.utm.getSelectedElementNames(string);
        if (stringArray != null && stringArray.length > 0) {
            if (string.equals("CurrentTopologyTree")) {
                this.selectedCurrentNode = (NetworkTopologyNode)this.allNodesHashMap.get(stringArray[0]);
                this.utm.setEnabled("Button1", this.selectedCurrentNode.supportsPing());
                this.setAttributes(string, this.selectedCurrentNode);
            } else if (string.equals("SavedTopologyTree")) {
                this.selectedSavedNode = (NetworkTopologyNode)this.allNodesHashMap.get(stringArray[0]);
                this.utm.setEnabled("Button2", this.selectedSavedNode.supportsPing());
                this.setAttributes(string, this.selectedSavedNode);
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopologyBean.selectionChanged()");
    }

    private void setAttributes(String string, NetworkTopologyNode networkTopologyNode) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> NetworkTopologyBean.setAttributes()");
        String string2 = networkTopologyNode.getAttributesString();
        if (string.equals("CurrentTopologyTree")) {
            this.utm.setValue("CurrentTopologyString", string2);
        } else if (string.equals("SavedTopologyTree")) {
            this.utm.setValue("SavedTopologyString", string2);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- NetworkTopologyBean.setAttributes()");
    }
}

